/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

public class GuiBookEntry
extends GuiBook
implements IComponentRenderContext {
    final BookEntry entry;
    BookPage leftPage;
    BookPage rightPage;

    public GuiBookEntry(Book book, BookEntry entry) {
        this(book, entry, 0);
    }

    public GuiBookEntry(Book book, BookEntry entry, int spread) {
        super(book, (class_2561)entry.getName());
        this.entry = entry;
        this.spread = spread;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.maxSpreads = (int)Math.ceil((float)this.entry.getPages().size() / 2.0f);
        this.setupPages();
    }

    @Override
    public void onFirstOpened() {
        int index;
        super.onFirstOpened();
        boolean dirty = false;
        String key = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        if (!data.viewedEntries.contains(key)) {
            data.viewedEntries.add(key);
            dirty = true;
            this.entry.markReadStateDirty();
        }
        if ((index = data.history.indexOf(key)) != 0) {
            if (index > 0) {
                data.history.remove(key);
            }
            data.history.add(0, key);
            while (data.history.size() > 13) {
                data.history.remove(13);
            }
            dirty = true;
        }
        if (dirty) {
            PersistentData.save();
        }
    }

    @Override
    void drawForegroundElements(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        this.drawPage(ms, this.leftPage, mouseX, mouseY, partialTicks);
        this.drawPage(ms, this.rightPage, mouseX, mouseY, partialTicks);
        if (this.rightPage == null) {
            GuiBookEntry.drawPageFiller(ms, this.leftPage.book);
        }
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.clickPage(this.leftPage, mouseX, mouseY, mouseButton) || this.clickPage(this.rightPage, mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    void drawPage(class_4587 ms, BookPage page, int mouseX, int mouseY, float pticks) {
        if (page == null) {
            return;
        }
        ms.method_22903();
        ms.method_22904((double)page.left, (double)page.top, 0.0);
        page.render(ms, mouseX - page.left, mouseY - page.top, pticks);
        ms.method_22909();
    }

    boolean clickPage(BookPage page, double mouseX, double mouseY, int mouseButton) {
        if (page != null) {
            return page.mouseClicked(mouseX - (double)page.left, mouseY - (double)page.top, mouseButton);
        }
        return false;
    }

    @Override
    void onPageChanged() {
        this.setupPages();
        this.needsBookmarkUpdate = true;
    }

    void setupPages() {
        if (this.leftPage != null) {
            this.leftPage.onHidden(this);
        }
        if (this.rightPage != null) {
            this.rightPage.onHidden(this);
        }
        List<BookPage> pages = this.entry.getPages();
        int leftNum = this.spread * 2;
        int rightNum = this.spread * 2 + 1;
        this.leftPage = leftNum < pages.size() ? pages.get(leftNum) : null;
        BookPage bookPage = this.rightPage = rightNum < pages.size() ? pages.get(rightNum) : null;
        if (this.leftPage != null) {
            this.leftPage.onDisplayed(this, 15, 18);
        }
        if (this.rightPage != null) {
            this.rightPage.onDisplayed(this, 141, 18);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GuiBookEntry && ((GuiBookEntry)obj).entry == this.entry && ((GuiBookEntry)obj).spread == this.spread;
    }

    public int hashCode() {
        return Objects.hashCode(this.entry) * 31 + Objects.hashCode(this.spread);
    }

    @Override
    public boolean canBeOpened() {
        return !this.entry.isLocked() && !this.equals(class_310.method_1551().field_1755);
    }

    @Override
    protected boolean shouldAddAddBookmarkButton() {
        return !this.isBookmarkedAlready();
    }

    boolean isBookmarkedAlready() {
        if (this.entry == null || this.entry.getId() == null) {
            return false;
        }
        String entryKey = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        for (PersistentData.DataHolder.BookData.Bookmark bookmark : data.bookmarks) {
            if (!bookmark.entry.equals(entryKey) || bookmark.page != this.spread) continue;
            return true;
        }
        return false;
    }

    @Override
    public void bookmarkThis() {
        String entryKey = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        data.bookmarks.add(new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.spread));
        PersistentData.save();
        this.needsBookmarkUpdate = true;
    }

    public static void displayOrBookmark(GuiBook currGui, BookEntry entry) {
        Book book = currGui.book;
        GuiBookEntry gui = new GuiBookEntry(currGui.book, entry);
        if (class_437.method_25442()) {
            PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(book);
            if (gui.isBookmarkedAlready()) {
                String key = entry.getId().toString();
                data.bookmarks.removeIf(bm -> bm.entry.equals(key) && bm.page == 0);
                PersistentData.save();
                currGui.needsBookmarkUpdate = true;
                return;
            }
            if (data.bookmarks.size() < 10) {
                gui.bookmarkThis();
                currGui.needsBookmarkUpdate = true;
                return;
            }
        }
        book.getContents().openLexiconGui(gui, true);
    }

    @Override
    public class_437 getGui() {
        return this;
    }

    @Override
    public class_2583 getFont() {
        return this.book.getFontStyle();
    }

    @Override
    public void renderItemStack(class_4587 ms, int x, int y, int mouseX, int mouseY, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        RenderHelper.transferMsToGl(ms, () -> {
            class_310.method_1551().method_1480().method_4023(stack, x, y);
            this.field_22787.method_1480().method_4025(this.field_22793, stack, x, y);
        });
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    @Override
    public void renderIngredient(class_4587 ms, int x, int y, int mouseX, int mouseY, class_1856 ingr) {
        class_1799[] stacks = ingr.method_8105();
        if (stacks.length > 0) {
            this.renderItemStack(ms, x, y, mouseX, mouseY, stacks[this.ticksInBook / 20 % stacks.length]);
        }
    }

    @Override
    public void setHoverTooltip(List<String> tooltip) {
        this.setTooltip(tooltip.stream().map(class_2585::new).collect(Collectors.toList()));
    }

    @Override
    public void setHoverTooltipComponents(@Nonnull List<class_2561> tooltip) {
        this.setTooltip(tooltip);
    }

    @Override
    public boolean isAreaHovered(int mouseX, int mouseY, int x, int y, int w, int h) {
        return this.isMouseInRelativeRange(mouseX, mouseY, x, y, w, h);
    }

    @Override
    public void registerButton(class_4185 button, int pageNum, Runnable onClick) {
        this.addWidget((class_339)button, pageNum);
    }

    @Override
    public void addWidget(class_339 widget, int pageNum) {
        widget.field_22760 = widget.field_22760 + (this.bookLeft + (pageNum % 2 == 0 ? 15 : 141));
        widget.field_22761 += this.bookTop;
        this.method_37063(widget);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean shouldAddMarkReadButton() {
        return false;
    }

    @Override
    public class_2960 getBookTexture() {
        return this.book.bookTexture;
    }

    @Override
    public class_2960 getCraftingTexture() {
        return this.book.craftingTexture;
    }

    @Override
    public int getTextColor() {
        return this.book.textColor;
    }

    @Override
    public int getHeaderColor() {
        return this.book.headerColor;
    }

    @Override
    public int getTicksInBook() {
        return this.ticksInBook;
    }
}

